﻿<?xml version="1.0" standalone="no"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output indent="yes"/>
	<xsl:template match="/">
		<xsl:element name="xsl:stylesheet">
			<xsl:attribute name="version">1.0</xsl:attribute>
			<xsl:element name="xsl:template">
				<xsl:attribute name="match">/</xsl:attribute>
				<xsl:variable name="sdk_platform"       select="substring(Root/Property[@NAME='PlatformID'], 2, 36)"/>
				<xsl:variable name="sdk_ceVersion"	select="Root/Property[@NAME='CEVersion']"/>
				<xsl:variable name="sdk_platformVersionPath">wce<xsl:number value="floor( $sdk_ceVersion div 100 ) * 100"/> </xsl:variable>
				<xsl:variable name="sdk_osVersion">
					<xsl:number value="$sdk_ceVersion * 10"/>
				</xsl:variable>
				<xsl:variable name="default_DeviceEmulator_Image" select="Root/PropertyBag[@NAME='DeviceEmulation']/Property[@NAME='Default Image']"/>
				<!-- substring( ..., 2, 36 ) is used to strip braces from a GUID -->
				<!-- !!! NOTE: This template is dependent on the sdk_dyn_InstallRootDir macro, the SDK installation root directory. -->
				<ADDONCONTAINER>
					<ADDON>
						<PLATFORMCONTAINER>
							<PLATFORM _InstallChildrenOnly="true">
								<xsl:attribute name="ID">
									<xsl:value-of select="$sdk_platform"/>
								</xsl:attribute>
								<DEVICECONTAINER>
									<!-- process each device emulation bag -->
									<xsl:for-each select="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag">
										<xsl:if test="Property[@NAME='Enabled']='1'">
											<DEVICE Protected="true">
												<xsl:attribute name="Name">
													<xsl:value-of select="Property[@NAME='ImageName']"/>
												</xsl:attribute>
												<xsl:attribute name="ID">
													<xsl:value-of select="substring(Property[@NAME='VMID'], 2, 36)"/>
												</xsl:attribute>
												<PROPERTYCONTAINER>
													<PROPERTY ID="OS_Version">
														<xsl:value-of select="$sdk_osVersion"/>
													</PROPERTY>
													<PROPERTY ID="OS">default</PROPERTY>
													<PROPERTY ID="Emulator" Protected="true">true</PROPERTY>
													<PROPERTY ID="CpuName">
														<xsl:value-of select="Property[@NAME='CpuName']"/>
													</PROPERTY>
													<PROPERTY ID="LocalClientFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ConManClient2.exe</PROPERTY>
													<PROPERTY ID="RemoteClientFile" Protected="true">\Windows\ConManClient2.exe</PROPERTY>
													<PROPERTY ID="LocalShutdownFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ClientShutdown.exe</PROPERTY>
													<PROPERTY ID="RemoteShutdownFile" Protected="true">\Windows\ClientShutdown.exe</PROPERTY>

													<PROPERTY ID="RemoteCcClientFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ConManClient2.exe</PROPERTY>
													<PROPERTY ID="RemoteCcShutdownFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ClientShutdown.exe</PROPERTY>
													<PROPERTY ID="RemoteCcTransportLoaderFile" Protected="true">%CSIDL_WINDOWS%\eDbgTL.dll</PROPERTY>
													<PROPERTY ID="RemoteCcCMAcceptFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\CMAccept.exe</PROPERTY>
													<!-- The current transport is the device emulator transport -->
													<PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B" Protected="false">26753017-B5BB-4b67-BEE3-862676DE23DC</PROPERTY>
													<!-- The current boostrap is the device emulator bootstrap -->
													<PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203" Protected="true">ECDA0E20-34EF-41CD-9574-A51C52B45037</PROPERTY>
													<xsl:comment> Transport service property overrides </xsl:comment>
													<PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B_ALL">
														<PROPERTYCONTAINER>
															<xsl:comment> TCP Transport </xsl:comment>
															<xsl:element name="xsl:element">
																<xsl:attribute name="name">PROPERTY</xsl:attribute>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/TRANSPORT_TRANSPORTNAME_TCPCONNECT</xsl:attribute>
																	</xsl:element>
																</xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">ID</xsl:attribute>D8E78E43-D8D6-4e57-8AD4-2164254C16D5
																</xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Protected</xsl:attribute>false
																</xsl:element>
																<PROPERTYCONTAINER>
																	<PROPERTY ID="default" Protected="false">no</PROPERTY>
																	<PROPERTY ID="type" Protected="false">emulator</PROPERTY>
																	<PROPERTY ID="LocalTransportFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\tcpconnectiona.dll</PROPERTY>
																	<PROPERTY ID="RemoteTransportFile" Protected="true">%CSIDL_WINDOWS%\tcpconnectiona.dll</PROPERTY>
																	<PROPERTY ID="ip" Protected="false">127.0.0.1</PROPERTY>
																	<PROPERTY ID="port" Protected="false">5654</PROPERTY>
																	<PROPERTY ID="useCustomPort" Protected="false">no</PROPERTY>
																	<PROPERTY ID="authenticate" Protected="false">false</PROPERTY>
																	<PROPERTY ID="disableauthentication" Protected="false">yes</PROPERTY>
																</PROPERTYCONTAINER>
															</xsl:element>
															<xsl:comment> DMA Transport </xsl:comment>
															<xsl:element name="xsl:element">
																<xsl:attribute name="name">PROPERTY</xsl:attribute>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/TRANSPORT_TRANSPORTNAME_DMA</xsl:attribute>
																	</xsl:element>
																</xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">ID</xsl:attribute>26753017-B5BB-4b67-BEE3-862676DE23DC
                                                                </xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Protected</xsl:attribute>false
																</xsl:element>
																<PROPERTYCONTAINER>
																	<PROPERTY ID="default" Protected="false">no</PROPERTY>
																	<PROPERTY ID="type" Protected="false">emulator</PROPERTY>
																	<PROPERTY ID="LocalTransportFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\devicedma.dll</PROPERTY>
																	<PROPERTY ID="RemoteTransportFile" Protected="true">%CSIDL_WINDOWS%\devicedma.dll</PROPERTY>
																	<PROPERTY ID="ip" Protected="false">127.0.0.1</PROPERTY>
																	<PROPERTY ID="port" Protected="false">5654</PROPERTY>
																	<PROPERTY ID="authenticate" Protected="false">false</PROPERTY>
																	<PROPERTY ID="disableauthentication" Protected="false">yes</PROPERTY>
																</PROPERTYCONTAINER>
															</xsl:element>
														</PROPERTYCONTAINER>
													</PROPERTY>
													<xsl:comment> Bootstrap service property overrides </xsl:comment>
													<PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203_ALL">
														<PROPERTYCONTAINER>
															<xsl:comment> Device Emulation Bootstrap </xsl:comment>
															<xsl:element name="xsl:element">
																<xsl:attribute name="name">PROPERTY</xsl:attribute>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_VISUALSTUDIO_SERVICECATEGORIES_8_0/STARTUP_STARTUPNAME_DEVICEEMULATION</xsl:attribute>
																	</xsl:element>
																</xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">ID</xsl:attribute>ECDA0E20-34EF-41CD-9574-A51C52B45037
																</xsl:element>
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Protected</xsl:attribute>false
																</xsl:element>
																<PROPERTYCONTAINER>
																	<PROPERTY ID="default" Protected="false">no</PROPERTY>
																	<PROPERTY ID="type" Protected="false">emulator</PROPERTY>
																	<PROPERTY ID="VMID" Protected="false">
																		{<xsl:value-of select="substring(Property[@NAME='VMID'], 2, 36)"/>}
																	</PROPERTY>
																	<xsl:if test="Property[@NAME='VMM_CLSID']!=''">
																	    <PROPERTY ID="VMM_CLSID">
																	        <xsl:value-of select="Property[@NAME='VMM_CLSID']"/>
																	    </PROPERTY>
																	</xsl:if>
																	<PROPERTY ID="AdditionalParameters" Protected="false">
																		<xsl:choose>
																			<xsl:when test="Property[@NAME='AdditionalParameters']!=''">
																				<xsl:value-of select="Property[@NAME='AdditionalParameters']"/>
																			</xsl:when>
																			<xsl:otherwise>
																				/funckey 193
																			</xsl:otherwise>
																		</xsl:choose>
																	</PROPERTY>
																	<xsl:if test="Property[@NAME='VMM_IID']!=''">
																	    <PROPERTY ID="VMM_IID">
																	        <xsl:value-of select="Property[@NAME='VMM_IID']"/>
																	    </PROPERTY>
																	</xsl:if>
																	<xsl:if test="Property[@NAME='DEVT_CLSID']!=''">
																	    <PROPERTY ID="DEVT_CLSID">
																	        <xsl:value-of select="Property[@NAME='DEVT_CLSID']"/>
																	    </PROPERTY>
																	</xsl:if>
																	<xsl:if test="Property[@NAME='DEVT_IID']!=''">
																	    <PROPERTY ID="DEVT_IID">
																	        <xsl:value-of select="Property[@NAME='DEVT_IID']"/>
																	    </PROPERTY>
																	</xsl:if>
																	<PROPERTY ID="OSBinImage" Protected="false">
																		<xsl:value-of select="$sdk_dyn_InstallRootDir"/>
																		<xsl:value-of select="Property[@NAME='Bin Dest']"/>
																	</PROPERTY>
																	<PROPERTY ID="ScreenWidth" Protected="false">
																		<xsl:choose>
																			<xsl:when test="Property[@NAME='Default Skin']!=''">
																				<xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
																				<xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='DisplayWidth']"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="PropertyBag[@NAME='SDK Skin']/Property[@NAME='DisplayWidth']"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</PROPERTY>
																	<PROPERTY ID="ScreenHeight" Protected="false">
																		<xsl:choose>
																			<xsl:when test="Property[@NAME='Default Skin']!=''">
																				<xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
																				<xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='DisplayHeight']"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="PropertyBag[@NAME='SDK Skin']/Property[@NAME='DisplayHeight']"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</PROPERTY>
																	<PROPERTY ID="ColorDepth" Protected="false">
																		<xsl:value-of select="Property[@NAME='BitDepth']"/>
																	</PROPERTY>
																	<PROPERTY ID="EthernetEnabled" Protected="false">no</PROPERTY>
																	<PROPERTY ID="RAMSize" Protected="false">
																		<xsl:value-of select="Property[@NAME='Memory']"/>
																	</PROPERTY>
																	<PROPERTY ID="HostKey" Protected="false">165</PROPERTY>
																	<PROPERTY ID="UseDefaultSaveState" Protected="false">true</PROPERTY>
																	<PROPERTY ID="SerialPort0" Name="SerialPort0"></PROPERTY>
																	<PROPERTY ID="SerialPort1" Protected="false"></PROPERTY>
																	<PROPERTY ID="SerialPort2" Protected="false"></PROPERTY>
																	<PROPERTY ID="ParallelPort" Protected="false"></PROPERTY>
																	<PROPERTY ID="AlwaysOnTop" Name="AlwaysOnTop">no</PROPERTY>
																	<PROPERTY ID="CreateConsole" Name="CreateConsole">no</PROPERTY>
																	<PROPERTY ID="CS8900Adapter" Name="CS8900Adapter">000000000000</PROPERTY>
																	<PROPERTY ID="CS8900EthernetEnabled" Name="CS8900EthernetEnabled">no</PROPERTY>
																	<PROPERTY ID="EnableToolTips" Name="EnableToolTips">no</PROPERTY>
																	<PROPERTY ID="FlashFile" Name="FlashFile"></PROPERTY>
																	<PROPERTY ID="HostOnlyEthernetEnabled" Name="HostOnlyEthernetEnabled">no</PROPERTY>
																	<PROPERTY ID="ImageAddress" Name="ImageAddress"></PROPERTY>
																	<PROPERTY ID="NE2000Adapter" Name="NE2000Adapter">000000000000</PROPERTY>
																	<PROPERTY ID="Orientation" Name="Orientation">0</PROPERTY>
																	<PROPERTY ID="ShowSkin" Name="ShowSkin">yes</PROPERTY>
																	<PROPERTY ID="SpecifyAddress" Name="SpecifyAddress">no</PROPERTY>
																	<PROPERTY ID="Zoom2x" Name="Zoom2x">no</PROPERTY>
																	<PROPERTY ID="Skin" Protected="false">
																		<xsl:choose>
																			<xsl:when test="Property[@NAME='Default Skin']!=''">
																				<xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
																				<xsl:value-of select="$sdk_dyn_InstallRootDir"/>
																				<xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='Destination']"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="$sdk_dyn_SDKRootDir"/>
																				<xsl:value-of select="PropertyBag[@NAME='SDK Skin']/Property[@NAME='Default']"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</PROPERTY>
																	<PROPERTY ID="SkinEngine" Protected="false" _UseVSRelativePath="true">smartdevices\emulators\skin.dll</PROPERTY>
																</PROPERTYCONTAINER>
															</xsl:element>
														</PROPERTYCONTAINER>
													</PROPERTY>
													<PROPERTY ID="OutputLocation">%CSIDL_PROGRAM_FILES%</PROPERTY>
													<PROPERTY ID="OutputLocation_ALL">
														<PROPERTYCONTAINER>
															<PROPERTY ID="\">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_ROOT</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_PERSONAL%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PERSONAL</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_PROGRAMS%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAMS</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_PROGRAM_FILES%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAM_FILES</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_APPDATA%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_APPDATA</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_COMMON_APPDATA%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_COMMON_APPDATA</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_WINDOWS%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_WINDOWS</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_FONTS%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_FONTS</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_STARTMENU%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTMENU</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
															<PROPERTY ID="%CSIDL_STARTUP%">
																<xsl:element name="xsl:attribute">
																	<xsl:attribute name="name">Name</xsl:attribute>
																	<xsl:element name="xsl:value-of">
																		<xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTUP</xsl:attribute>
																	</xsl:element>
																</xsl:element>
															</PROPERTY>
														</PROPERTYCONTAINER>
													</PROPERTY>
												</PROPERTYCONTAINER>
											</DEVICE>
										</xsl:if>
									</xsl:for-each>
								</DEVICECONTAINER>
								<FORMFACTORCONTAINER>
									<xsl:choose>
										<xsl:when test="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag/PropertyBag[@NAME='Skins']/PropertyBag/* !=''">
											<!-- process each device emulation bag -->
											<xsl:for-each select="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag">
												<xsl:if test="Property[@NAME='Enabled']='1'">
													<xsl:for-each select="PropertyBag[@NAME='Skins']/PropertyBag">
														<xsl:element name="FORMFACTOR">
															<xsl:attribute name="ID">
																<xsl:value-of select="@NAME"/>
															</xsl:attribute>
															<xsl:attribute name="Name">
																<xsl:value-of select="Property[@NAME='Display_Name']"/>
															</xsl:attribute>
															<xsl:attribute name="Protected">true</xsl:attribute>
															<PROPERTYCONTAINER>
																<xsl:choose>
																	<xsl:when test="../../Property[@NAME='DPIX']!=''">
																		<PROPERTY ID="DPIX">
																			<xsl:value-of select="../../Property[@NAME='DPIX']"/>
																		</PROPERTY>
																	</xsl:when>
																	<xsl:otherwise>
																		<PROPERTY ID="DPIX">96</PROPERTY>
																	</xsl:otherwise>
																</xsl:choose>
																<xsl:choose>
																	<xsl:when test="../../Property[@NAME='DPIY']!=''">
																		<PROPERTY ID="DPIY">
																			<xsl:value-of select="../../Property[@NAME='DPIY']"/>
																		</PROPERTY>
																	</xsl:when>
																	<xsl:otherwise>
																		<PROPERTY ID="DPIY">96</PROPERTY>
																	</xsl:otherwise>
																</xsl:choose>
																<PROPERTY ID="SHOWSKIN">true</PROPERTY>
																<xsl:choose>
																	<xsl:when test="../../Property[@NAME='SupportRotation']='1'">
													                                    <PROPERTY ID="SupportRotation">true</PROPERTY>
																	</xsl:when>
																	<xsl:otherwise>
																		<PROPERTY ID="SupportRotation">false</PROPERTY>
																	</xsl:otherwise>
																</xsl:choose>
																<PROPERTY ID="DisplayWidth">
																	<xsl:value-of select="Property[@NAME='DisplayWidth']"/>
																</PROPERTY>
																<PROPERTY ID="DisplayHeight">
																	<xsl:value-of select="Property[@NAME='DisplayHeight']"/>
																</PROPERTY>
																<PROPERTY ID="ColorDepth">
																	<xsl:value-of select="../../Property[@NAME='BitDepth']"/>
																</PROPERTY>
																<PROPERTY ID="Skin" Protected="false">
																	<xsl:value-of select="$sdk_dyn_InstallRootDir"/>
																	<xsl:value-of select="Property[@NAME='Destination']"/>
																</PROPERTY>
																<xsl:choose>
																	<xsl:when test="Property[@NAME='KeyMapping']!=''">
																		<PROPERTY ID="KeyMapping">
																			<xsl:value-of select="$sdk_dyn_InstallRootDir"/>
																			<xsl:value-of select="Property[@NAME='KeyMapping']"/>
																		</PROPERTY>
																	</xsl:when>
																	<xsl:otherwise>
																		<PROPERTY ID="KeyMapping"></PROPERTY>
																	</xsl:otherwise>
																</xsl:choose>
															</PROPERTYCONTAINER>
														</xsl:element>
													</xsl:for-each>
												</xsl:if>
											</xsl:for-each>
										</xsl:when>
									</xsl:choose>
								</FORMFACTORCONTAINER>
							</PLATFORM>
						</PLATFORMCONTAINER>
					</ADDON>
				</ADDONCONTAINER>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
